/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
typedef struct Lang_Object_Type
  {
     unsigned short type;
     long value;
  }
Lang_Object_Type;

/* The first 8 bits of type specify the basic type, e.g., intrinsic, block,
   etc...  The next 8 bits (high byte) are extended attributes which 
   are specific to the type, e.g., local variable of type string.
   
   For Lang_Functions, the higher order byte of type is the number of
   local variables 0->255 */

#define LANG_INTRINSIC 	0x01
#define LANG_FUNCTION  	0x02
#define LANG_BLOCK      0x03
#define LANG_GVARIABLE 	0x04
#define LANG_LVARIABLE	0x05
#define LANG_DIRECTIVE	0x06
#define LANG_LITERAL	0x07           /* constant objects */
#define LANG_DATA	0x08           /* real objects which may be destroyed */
#define LANG_BINARY	0x09
#define LANG_CMP	0x10
#define LANG_IVARIABLE 	0x11           /* intrinsic variables */
#define LANG_RETURN	0x12
#define LANG_BREAK	0x13
#define LANG_CONTINUE	0x14
#define LANG_UNARY	0x15
#define LANG_LABEL	0x16

/* directive subtypes */
#define LANG_LOOP_MASK	0x80
#define LANG_LOOP	0x81
#define LANG_WHILE	0x82
#define LANG_FOR	0x83
#define LANG_FOREVER	0x84

#define LANG_IF_MASK	0x40
#define LANG_IF		0x41
#define LANG_IFNOT	0x42
#define LANG_ELSE	0x43


/* local, global variable assignments */
#define LANG_EQS_MASK	0x20
#define LANG_LEQS	0x21
#define LANG_GEQS	0x22
#define LANG_IEQS	0x23

#define LANG_ELSE_MASK	0x10
#define LANG_ANDELSE	0x11
#define LANG_ORELSE	0x12
#define LANG_SWITCH	0x13

/* subtypes of literal (static) and data (dynamic)*/
#define VOID_TYPE	1
#define INT_TYPE 	2
#define STRING_TYPE 	3
#define ARRAY_TYPE	4
#ifdef FLOAT_TYPE
#undef FLOAT_TYPE
#define FLOAT_TYPE	5
#endif

/* subtypes for INTRINSIC function type */
/* lower 4 bits represent the return type, e.g., void, int, etc... 
   The next 4 bits represent the number of parameters, 0 -> 15 */
#define LANG_INTRINSIC_ARGC(f) ((f).type >> 12)
#define LANG_INTRINSIC_TYPE(f) (((f).type & 0x0F00) >> 8)

/* binary stypes and cmp stypes */
#define LANG_EQ		1
#define LANG_NE		2
#define LANG_GT		3
#define LANG_GE		4
#define LANG_LT		5
#define LANG_LE		6
#define LANG_OR		7
#define LANG_PLUS	8
#define LANG_MINUS	9
#define LANG_TIMES	10
#define LANG_DIVIDE	11
#define LANG_AND	12
#define LANG_BAND	13
#define LANG_BOR	14
#define LANG_BXOR	15
#define LANG_SHL	16
#define LANG_SHR	17


/* UNARY subtypes */
#define LANG_NOT	1
#define LANG_CHS	2
#define LANG_BNOT	3


extern int (*Lang_Error_Routine)(char *);   /* external routine */
extern int (*User_Load_File)(char *);   /* external routine */

/* error codes */
#define UNDEFINED_NAME		1
#define SYNTAX_ERROR		2
#define STACK_OVERFLOW		3
#define STACK_UNDERFLOW		4
#define DUPLICATE_DEFINITION	5
#define TYPE_MISMATCH		6

extern void init_lang(void);  /* pass the error routine */
extern void add_intrinsic(char *, long, unsigned char, int);
extern void add_variable(char *, long, int);
extern char *interpret(char *);
extern void lang_doerror(char *);
extern void lang_restart(void);
extern int lang_load_file(char *);
extern int lang_run_hooks(char *, char *);
extern void lang_push_string(char *);
extern void lang_push_integer(int);
extern int lang_pop_integer(int *);
extern volatile int Lang_Error;

#ifdef Future_Slang
extern void print_stack(void);
#endif
